package event;

import extension.file.EasyIni;
import servercore.http.HttpServer;
public class CUIStart {

	public static void main(String[] args) {
		EasyIni ini = new EasyIni("./config/web_server.ini");
		HttpServer.setRecvPort(ini.getPro("port"));
		HttpServer.setRootDirPath(ini.getPro("irDir"));
		HttpServer.setUseSecurity(ini.getPro("userSecury"));
		HttpServer.setUseCompress(ini.getPro("compress"));
		String exIniPath = ini.getPro("loadInit");
		if(exIniPath != null) {
			HttpServer.setLoadIni(new EasyIni(exIniPath));
		}
		HttpServer server = new HttpServer();
		server.start();

		try {
			server.join();
		} catch (InterruptedException e) {}

	}
}
